<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['middleware' => ['localization']], function () {

    Route::post('/login', 'App\Http\Controllers\API\AuthController@login');
    Route::post('/social/login', 'App\Http\Controllers\API\AuthController@socialLogin');
    Route::get('/logout', 'App\Http\Controllers\API\AuthController@logout');
    Route::post('/forgot-password', 'App\Http\Controllers\API\AuthController@forgotPassword');
    Route::post('/verifyOtp', 'App\Http\Controllers\API\AuthController@verifyOtp');
    Route::post('/sendOtp', 'App\Http\Controllers\API\AuthController@sendOtp');
    Route::post('/verifySendOtp', 'App\Http\Controllers\API\AuthController@verifySendOtp');
    Route::post('/update-password', 'App\Http\Controllers\API\AuthController@updatePassword');
    Route::post('/register', 'App\Http\Controllers\API\AuthController@register');

    // Zones
    Route::apiResource('zone', 'App\Http\Controllers\API\ZoneController', ['except' => ['show']]);
    Route::get('zone-by-point', 'App\Http\Controllers\API\ZoneController@getZoneIds')->name('get.zoneId');

    // Countries & States
    Route::apiResource('state', 'App\Http\Controllers\API\StateController');
    Route::post('add-state', 'App\Http\Controllers\API\StateController@store');
    Route::apiResource('country', 'App\Http\Controllers\API\CountryController');

    // Settings & Options
    Route::get('settings', 'App\Http\Controllers\API\SettingController@frontSettings');

    // Payment Methods
    Route::get('payment-methods', 'App\Http\Controllers\API\PaymentMethodController@index');

    // Role With Permissions
    Route::apiResource('role', 'App\Http\Controllers\API\RoleController');

    // Users
    Route::get('user', 'App\Http\Controllers\API\UserController@index');

    //Self
    Route::get('self', 'App\Http\Controllers\API\AccountController@self');
    Route::put('zone-update','App\Http\Controllers\API\AccountController@updateUserZone');
    
    // Providers
    Route::get('provider', 'App\Http\Controllers\API\ProviderController@index');
    Route::get('provider/{id}', 'App\Http\Controllers\API\ProviderController@show');
    Route::get('providerServices', 'App\Http\Controllers\API\ProviderController@getProviderServices');
    Route::post('provider-zone/update', 'App\Http\Controllers\API\ProviderController@updateProviderZones');

    // Banner
    Route::get('banner', 'App\Http\Controllers\API\BannerController@index');
    Route::get('banner/{id}', 'App\Http\Controllers\API\BannerController@show');

    // Servicemans
    Route::apiResource('serviceman', 'App\Http\Controllers\API\ServicemanController');

    // Service
    Route::get('service', 'App\Http\Controllers\API\ServiceController@index');
    Route::get('featuredServices', 'App\Http\Controllers\API\ServiceController@isFeatured');
    Route::get('servicePackages', 'App\Http\Controllers\API\ServiceController@servicePackages');
    Route::get('servicePackages/{id}', 'App\Http\Controllers\API\ServiceController@servicePackages');

    // Categories
    Route::get('category', 'App\Http\Controllers\API\CategoryController@index');
    Route::get('categoryList', 'App\Http\Controllers\API\CategoryController@getAllCategories');
    Route::get('category/{id}', 'App\Http\Controllers\API\CategoryController@show');

    // Currency
    Route::get('currency', 'App\Http\Controllers\API\CurrencyController@index');

    // Blog
    Route::get('blog', 'App\Http\Controllers\API\BlogController@index');

    // Blog-Category
    Route::get('blog-category', 'App\Http\Controllers\API\BlogController@index');

    // Pages
    Route::get('page', 'App\Http\Controllers\API\PageController@index');

    //Service FAQ's
    Route::get('service-faqs', 'App\Http\Controllers\API\ServiceController@serviceFAQS');

    Route::get('/providers/highest-ratings', 'App\Http\Controllers\API\ProviderController@getUsersWithHighestRatings');

    // Order Status
    Route::apiResource('bookingStatus', 'App\Http\Controllers\API\BookingStatusController', [
        'only' => ['index', 'show'],
    ]);

    /*------------------------------------ Provider API's --------------------------------------------------------- */

    // Auth API's
    Route::post('/provider-register', 'App\Http\Controllers\API\AuthController@registerProvider');

    //Document
    Route::apiResource('document', 'App\Http\Controllers\API\DocumentController', [
        'only' => ['index', 'show'],
    ]);

    //Tax
    Route::apiResource('tax', 'App\Http\Controllers\API\TaxController', [
        'only' => ['index', 'show'],
    ]);

    //Language
    Route::apiResource('language', 'App\Http\Controllers\API\LanguageController', [
        'only' => ['index', 'show'],
    ]);

    // System Language
    Route::apiResource('systemLang', 'App\Http\Controllers\API\SystemLangController', [
        'only' => ['index'],
    ]);

    // For User App
    Route::get('systemLang/translate/{lang?}', 'App\Http\Controllers\API\SystemLangController@getTranslate');

    // For Provider App
    Route::get('systemLang/provider/translate/{lang?}', 'App\Http\Controllers\API\SystemLangController@getProviderTranslate');

    /*------------------------------------ End Provider API's ------------------------------------------------------ */

    Route::middleware('auth:sanctum')->group(function () {

        Route::post('addserviceProofs', 'App\Http\Controllers\API\BookingController@addserviceProofs');
        Route::post('updateserviceProofs', 'App\Http\Controllers\API\BookingController@updateserviceProofs');
        Route::get('statistics/count', 'App\Http\Controllers\API\HomeController@index');
        Route::get('home/chart', 'App\Http\Controllers\API\HomeController@chart');
        Route::get('home/get-top-earning-categories', 'App\Http\Controllers\API\HomeController@getTopCategoryEarnings');
        Route::put('updateProfile', 'App\Http\Controllers\API\AccountController@updateProfile');
        Route::post('store/notification', 'App\Http\Controllers\API\NotificationController@store');
        Route::post('dummy/notification', 'App\Http\Controllers\API\NotificationController@dummyNotification');
        Route::post('update-company-details', 'App\Http\Controllers\API\ProviderController@updateCompanyDetails');

        // Delete Account
        Route::get('deleteAccount', 'App\Http\Controllers\API\AccountController@deleteAccount')->name('deleteAccount');

        Route::apiResource('user', 'App\Http\Controllers\API\UserController', [
            'only' => ['store', 'update', 'destroy'],
        ]);

        // category-commission
        Route::get('category-commission', 'App\Http\Controllers\API\CategoryController@getCategoryCommission');

        //Provider
        Route::apiResource('provider', 'App\Http\Controllers\API\ProviderController', [
            'only' => ['store', 'update', 'destroy'],
        ]);

        //Service
        Route::apiResource('service', 'App\Http\Controllers\API\ServiceController', [
            'only' => ['store', 'update', 'destroy'],
        ]);
        Route::post('addServiceAddress/{id}', 'App\Http\Controllers\API\ServiceController@storeServiceAddresses');
        Route::delete('deleteServiceAddress/{id}/{address_id}', 'App\Http\Controllers\API\ServiceController@deleteServiceAddresses');

        //Service Package
        Route::apiResource('service-package', 'App\Http\Controllers\API\ServicePackageController', [
            'only' => ['store', 'update', 'destroy','show'],
        ]);

        //Serviceman
        Route::apiResource('serviceman', 'App\Http\Controllers\API\ServicemanController', [
            'only' => ['store', 'update', 'destroy'],
        ]);

        //Bank Detail
        Route::apiResource('bankDetail', 'App\Http\Controllers\API\BankDetailController')->except(['update']);
        Route::put('bankDetail/{user_id}', 'App\Http\Controllers\API\BankDetailController@update')->middleware('can:backend.bank_detail.edit');


        Route::get('company/{companyId}/addresses', 'App\Http\Controllers\API\CompanyController@getCompanyAddresses');
        Route::get('provider-time-slot/{provider_id}', 'App\Http\Controllers\API\ProviderController@providerTimeSlot');
        Route::post('provider-time-slot', 'App\Http\Controllers\API\ProviderController@storeProviderTimeSlot');
        Route::put('update-provider-time-slot', 'App\Http\Controllers\API\ProviderController@updateProviderTimeSlot');

        //Rate App
        Route::post('rate-app', 'App\Http\Controllers\API\RateAppController@store');

        //Address Status
        Route::post('changeAddressStatus/{id}', 'App\Http\Controllers\API\AddressController@changeAddressStatus');

        Route::apiResource('banner', 'App\Http\Controllers\API\BannerController', [
            'only' => ['store', 'update', 'destroy'],
        ]);

        Route::apiResource('category', 'App\Http\Controllers\API\CategoryController', [
            'only' => ['store', 'update', 'destroy'],
        ]);

        Route::apiResource('currency', 'App\Http\Controllers\API\CurrencyController', [
            'only' => ['store', 'update', 'destroy'],
        ]);

        //Booking
        Route::apiResource('booking', 'App\Http\Controllers\API\BookingController');
        Route::get('isValidTimeSlot', 'App\Http\Controllers\API\ProviderController@isValidTimeSlot');
        Route::post('checkout', 'App\Http\Controllers\API\CheckoutController@verifyCheckout');
        Route::post('booking/assign', 'App\Http\Controllers\API\BookingController@assign');
        Route::post('booking/add-extra-charges', 'App\Http\Controllers\API\BookingController@addExtraCharges');
        Route::post('booking/payment', 'App\Http\Controllers\API\BookingController@payment');

        //Payment
        Route::get('verifyPayment', 'App\Http\Controllers\API\BookingController@verifyPayment');
        Route::post('re-payment', 'App\Http\Controllers\API\BookingController@rePayment');

        // Booking Status
        Route::apiResource('bookingStatus', 'App\Http\Controllers\API\BookingStatusController', [
            'only' => ['store', 'update', 'destroy'],
        ]);
        Route::post('bookingStatus/deleteAll', 'App\Http\Controllers\API\BookingStatusController@deleteAll');
        Route::put('bookingStatus/{id}/{status}', 'App\Http\Controllers\API\BookingStatusController@status');

        // Fabourite-List
        Route::apiResource('favourite-list', 'App\Http\Controllers\API\FavouriteListController');

        Route::put('address/isPrimary/{id}', 'App\Http\Controllers\API\AddressController@isPrimary');

        Route::apiResource('address', 'App\Http\Controllers\API\AddressController', [
            'only' => ['index', 'store', 'update', 'destroy'],
        ]);

        // Notifications
        Route::get('notifications', 'App\Http\Controllers\API\NotificationController@index');
        Route::get('clear-notifications', 'App\Http\Controllers\API\NotificationController@clearNotifications');
        Route::put('notifications/markAsRead', 'App\Http\Controllers\API\NotificationController@markAsRead');
        Route::delete('notifications/{id}', 'App\Http\Controllers\API\NotificationController@destroy');

        // Reviews
        Route::apiResource('review', 'App\Http\Controllers\API\ReviewController');
        Route::post('review/deleteAll', 'App\Http\Controllers\API\ReviewController@deleteAll');

        // Wallets
        Route::get('wallet/consumer', 'App\Http\Controllers\API\WalletController@index');
        Route::post('credit/wallet', 'App\Http\Controllers\API\WalletController@credit');
        Route::post('debit/wallet', 'App\Http\Controllers\API\WalletController@debit');
        Route::post('provider/top-up', 'App\Http\Controllers\API\ProviderWalletController@topUp');
        Route::post('provider/withdraw-request', 'App\Http\Controllers\API\ProviderWalletController@withdrawRequest');
        Route::post('consumer/top-up', 'App\Http\Controllers\API\WalletController@topUp');

        // Provider Wallets
        Route::get('wallet/provider', 'App\Http\Controllers\API\ProviderWalletController@index')->middleware('can:backend.provider_wallet.index');
        Route::post('debit/providerWallet', 'App\Http\Controllers\API\ProviderWalletController@debit')->middleware('can:backend.provider_wallet.debit');
        Route::post('credit/providerWallet', 'App\Http\Controllers\API\ProviderWalletController@credit')->middleware('can:backend.provider_wallet.credit');

        // Serviceman Wallets
        Route::get('wallet/serviceman', 'App\Http\Controllers\API\ServicemanWalletController@index')->middleware('can:backend.serviceman_wallet.index');
        Route::post('serviceman/top-up', 'App\Http\Controllers\API\ServicemanWalletController@topUp')->middleware('can:backend.serviceman_withdraw_request.create');

        // Commission Histories
        Route::apiResource('commissionHistory', 'App\Http\Controllers\API\CommissionHistoryController', [
            'only' => ['index', 'show'],
        ]);

        // Delete Account
        Route::get('deleteAccount', 'App\Http\Controllers\API\AccountController@deleteAccount')->name('deleteAccount');

        // Account
        Route::put('update-password', 'App\Http\Controllers\API\AccountController@updatePassword');

        //verify serviceman
        Route::get('verify-user/{userId}', 'App\Http\Controllers\API\DocumentController@verifyUserDocument');
        Route::get('userDocuments/{userId}', 'App\Http\Controllers\API\DocumentController@getUserDocuments');

        //upload provider document
        Route::post('/upload-provider-document', 'App\Http\Controllers\API\DocumentController@uploadProviderDocument');

        // Bids
        Route::apiResource('bid','App\Http\Controllers\API\BidController',['except' => ['show']]);

        // Service Requests
        Route::apiResource('serviceRequest','App\Http\Controllers\API\ServiceRequestController');
    });
});
